<?php
// app/Support/TalentaHmac.php

namespace App\Support;

class TalentaHmac
{
    /**
     * Build Authorization + Date headers seperti di Postman:
     * stringToSign = "date: {date}\n{METHOD} {path_with_query} HTTP/1.1"
     */
    public static function buildHeaders(string $method, string $fullUrl, array $query, string $username, string $secret): array
    {
        $method = strtoupper($method);

        // Ambil path dari URL, lalu kita tambahkan query yang AKAN kita kirim
        $parsed = parse_url($fullUrl);
        $path   = $parsed['path'] ?? '/';

        // IMPORTANT: query harus sama dengan yang dikirim di request
        $queryString = '';
        if (!empty($query)) {
            // Gunakan RFC3986 agar encoding stabil
            $queryString = http_build_query($query, '', '&', PHP_QUERY_RFC3986);
            $path .= '?' . $queryString;
        }

        // Date RFC 1123 (UTC) -> sama seperti new Date().toUTCString() di Postman
        $date = gmdate('D, d M Y H:i:s') . ' GMT';

        // request-line
        $requestLine = $method . ' ' . $path . ' HTTP/1.1';

        // stringToSign
        $stringToSign = "date: {$date}\n{$requestLine}";

        // HMAC SHA256 -> base64
        $digest    = hash_hmac('sha256', $stringToSign, $secret, true);
        $signature = base64_encode($digest);

        $authHeader = sprintf(
            'hmac username="%s", algorithm="hmac-sha256", headers="date request-line", signature="%s"',
            $username,
            $signature
        );

        return [
            'Authorization' => $authHeader,
            'Date'          => $date,
            'Accept'        => 'application/json',
        ];
    }
}
